#!/usr/bin/perl
#
# UO install script by Erik Arneson <lazarus@mind.net>
# If you see me in-game, tell me you use Linux!
# (I play Bekki Random on Lake Superior!)

my $srcdir = "/mnt/cdrom";
my $destdir = ".";
my $inst = "partial";
my @instfiles;
my ($inf,$outf);

if ($#ARGV != 2) {
  printf "Usage:  install partial|full sourcedir destdir\n";
  exit 0;
}
else {
  ($inst,$srcdir,$destdir) = @ARGV;
  if (($inst ne "partial") && ($inst ne "full")) {
    printf "Installation method must be 'full' or 'partial'.\n";
    exit 0;
  }
  &init();
}

if (! -f $srcdir . "/client/version.dat") {
  printf "This does not appear to be an Ultima Online CD.\n";
  exit 0;
}

if (! -d $destdir) {
  mkdir($destdir,0700) || die "$destdir: $!\n";
}
mkdir($destdir . "/tutorial",0700) || die "$destdir: $!\n";
mkdir($destdir . "/patch", 0700) || die "$destdir: $!\n";

foreach $i (@instfiles) {
  printf "Copying $i\n";
#  next;  # Debugging purposes.
  $inf = $srcdir . "/client/" . $i;
  $outf = $destdir . "/" . $i;
  system("/bin/cp $inf $outf");
#  link($srcdir . "/client/" . $i, $destdir . "/" . $i) || die "$i: $!\n";
  chmod(0600,$outf);
}

&makecfg();

printf "Installation complete.\n";
exit 1;

sub makecfg {
  my $uocfg = $destdir . "/uo.cfg";
  my $distcfg = $srcdir . "/client/uoreg.cfg";
  my ($var,$val,$dpath);

  if ($inst eq "partial") {
    $dpath = $srcdir . "/client";
  }
  else {
    $dpath = $destdir;
  }
  printf "Making uo.cfg file...\n";
  open(INCFG,"<$distcfg") || die "$!\n";
  open(OUTCFG,">$uocfg") || die "$!\n";
  while(<INCFG>) {
    s/\r//g;
    chomp;
    if (/^$/) { next; }
    ($var,$val) = split(/=/);
    if ($var eq "CdRomDataPath") {
      $val = $dpath;
    }
    elsif ($var eq "HdUsage") {
      $val = "max" unless $inst eq "partial";
    }
    printf OUTCFG "%s=%s\n", $var, $val;
  }
  printf OUTCFG "ChestOpening=off\n";
  close(INCFG);
  close(OUTCFG);
}

sub init {
  if ($inst eq "full") {
    (@instfiles) = qw|anim.idx anim.mul animals.txt animdata.mul animinfo.mul art.mul artidx.mul birds.txt blues.txt credits.txt default.mac fonts.mul greens.txt gumpart.mul gumpidx.mul hairhue.txt hues.mul ignore.lst light.mul lightidx.mul login.cfg macros.txt map0.mul metals.txt multi.idx multi.mul multimap.rle neutrals.txt obscene.lst oranges.txt pinkpur.txt radarcol.mul reds.txt regions.mul skillgrp.mul skills.idx skills.mul skinhue.txt slimes.txt snakes.txt sound.mul soundidx.mul staidx0.mul statics0.mul texidx.mul texmaps.mul tiledata.mul tutorial/1gen.tga tutorial/2gen.tga tutorial/3gen.tga tutorial/4gen.tga tutorial/5gen.tga tutorial/6gen.tga tutorial/skill01.tga tutorial/skill02.tga tutorial/skill03.tga tutorial/skill04.tga tutorial/skill05.tga tutorial/skill06.tga tutorial/skill07.tga tutorial/skill08.tga tutorial/skill09.tga tutorial/skill10.tga tutorial/skill11.tga tutorial/skill12.tga tutorial/skill13.tga tutorial/skill14.tga tutorial/skill15.tga tutorial/skill16.tga tutorial/skill17.tga tutorial/skill18.tga tutorial/skill19.tga tutorial/skill20.tga tutorial/skill21.tga tutorial/skill22.tga tutorial/skill23.tga tutorial/skill24.tga tutorial/skill25.tga tutorial/skill26.tga tutorial/skill27.tga tutorial/skill28.tga tutorial/skill29.tga tutorial/skill30.tga tutorial/skill31.tga tutorial/skill32.tga tutorial/skill33.tga tutorial/skill34.tga tutorial/skill35.tga tutorial/skill36.tga tutorial/skill37.tga tutorial/skill38.tga tutorial/skill39.tga tutorial/skill40.tga tutorial/skill41.tga tutorial/skill42.tga tutorial/skill43.tga tutorial/skill44.tga tutorial/skill45.tga tutorial/skill46.tga version.dat yellows.txt|;
  }
  else {
    (@instfiles) = qw|anim.idx anim.mul animals.txt animdata.mul animinfo.mul art.mul artidx.mul birds.txt blues.txt credits.txt default.mac fonts.mul greens.txt gumpart.mul gumpidx.mul hairhue.txt hues.mul ignore.lst light.mul lightidx.mul login.cfg macros.txt metals.txt multimap.rle neutrals.txt obscene.lst oranges.txt pinkpur.txt radarcol.mul reds.txt regions.mul skillgrp.mul skinhue.txt slimes.txt snakes.txt tiledata.mul version.dat version.txt yellows.txt|;
  }
}

